-------------------------------------------------------------------
-- added to make below compile
-------------------------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
package test is
  function f_delay (sig : std_logic; rise : time; fall : time) return time;
end test;

package body test is
  function f_delay (sig : std_logic; rise : time; fall : time) return time is
  begin
    if (sig = '1') then 
      return rise;
    else 
      return fall;
    end if;
  end f_delay;
end test;
--------------------------------------------------------------------
  
PACKAGE gen_cond IS    
  TYPE t_checks IS ( onn, off); 
END gen_cond;
 
USE WORK.gen_cond.ALL;
---------------------------------------------------------------------
use work.test.all;
---------------------------------------------------------------------
LIBRARY IEEE; 

USE IEEE.std_logic_1164.ALL; 
ENTITY dff IS    
  GENERIC( timing_checks : t_checks;
           setup, qrise, qfall, qbrise, qbfall : time);    
  PORT( din, clk : IN std_logic;          
        q, qb : OUT std_logic); 
END dff; 

ARCHITECTURE condition OF dff IS 
BEGIN    
  G1 : IF (timing_checks = onn) GENERATE        
    ASSERT ( din'LAST_EVENT > setup)
      REPORT "setup violation"            
      SEVERITY ERROR;    
  END GENERATE;
    
  PROCESS(clk)        
    VARIABLE int_qb : std_logic;    
  BEGIN        
    IF (clk = '1') AND (clk'EVENT) AND (clk'LAST_VALUE = '0') THEN
      int_qb := not din;
            
      q <= din AFTER f_delay( din, qrise, qfall);

      qb <= int_qb AFTER f_delay( int_qb, qbrise, qbfall);        
    END IF;    
  END PROCESS; 
END condition;


